let assetGroupY = 0;
let scrollStatus = false;
let waitForIt;
let frameCount = 1;

const urlParams = new URLSearchParams(window.location.search);
let disableAnimate = urlParams.get('disableAnimate');

const posterCollection = [];
const scene = new THREE.Scene();
const renderer = new THREE.WebGLRenderer({ antialias: true });
const posterShape = new THREE.Shape();

const posterSize = {
    h: 40,
    w: 27,
    padding: 2,
    cols: 11,
    rows: 10,
};

const canvasSize = {
    h: window.innerWidth * 414 / 1075,
    w: window.innerWidth,
};

renderer.setPixelRatio(window.devicePixelRatio);
renderer.setSize(canvasSize.w, canvasSize.h);

roundedRect(posterShape, 0, 0, posterSize.w, posterSize.h, 3);
const posterGeometry = new THREE.ShapeGeometry(posterShape);

const startingY = -posterSize.h - posterSize.padding;
const assetGroup = new THREE.Group();
assetGroup.position.y = startingY;
assetGroup.position.x =
    -((posterSize.w * posterSize.cols) +
     (posterSize.padding * (posterSize.cols - 1))) / 2;

scene.add(assetGroup);

const camera = new THREE.PerspectiveCamera(
    75,
    (canvasSize.w / canvasSize.h) * 0.5,
    0.01,
    1000
);

camera.rotation.x = 0.6;
camera.position.z = 100;
camera.position.y = posterSize.h * 1.5;

const spotLight = new THREE.PointLight(0xffffff, 2500, 500);
spotLight.position.set(0, posterSize.h * 1.5, 50);
scene.add(spotLight);

document.querySelector('.posters').prepend(renderer.domElement);

init();
animate();

document.addEventListener('mousewheel', e => {
    clearTimeout(waitForIt);
    scrollStatus = true;
    scrollPosters(Math.abs(e.deltaY));

    waitForIt = setTimeout(() => {
        scrollStatus = false;
    }, 50);
});

function animate() {
    if (frameCount % 3 === 0) {
        if (!scrollStatus && !disableAnimate) {
            scrollPosters(0.3);
        }

        frameCount = 1;
        assetGroup.position.y = assetGroupY;
        renderer.render(scene, camera);
    } else {
        frameCount++;
    }

    requestAnimationFrame(animate);
}

function scrollPosters(moveY = 0.1) {
    if (assetGroup.position.y >= 0) {
        loopPosters();
        assetGroupY = startingY;
    } else {
        assetGroupY += moveY;
    }
}

function loopPosters() {
    if (!posterCollection.length) return;

    const lastY =
        (posterSize.h * posterCollection.length) +
        (posterSize.padding * (posterCollection.length - 1));

    posterCollection.forEach(row => {
        if (row.position.y >= lastY) {
            row.position.y = -startingY;
        } else {
            row.position.y += -startingY;
        }
    });
}

async function init() {
    const response = await fetch("https://inertia.uxbyalia.com/posters/images.json");
    const posters = await response.json();

    const assetList = shuffleList([...posters])
        .slice(0, posterSize.cols * posterSize.rows);

    renderPosters(assetList);
}

function renderPosters(assetList) {
    let x = 0;
    let y = 0;

    const textureLoader = new THREE.TextureLoader();
    let rowGroup;

    assetList.forEach((imagePath, i) => {

        if (i % posterSize.cols === 0) {
            y += posterSize.h + posterSize.padding;
            x = 0;

            rowGroup = new THREE.Group();
            rowGroup.position.y = y;
            assetGroup.add(rowGroup);
            posterCollection.push(rowGroup);
        } else {
            x += posterSize.w + posterSize.padding;
        }

        const texture = textureLoader.load(imagePath);
        texture.colorSpace = THREE.SRGBColorSpace;
        texture.wrapS = THREE.ClampToEdgeWrapping;
        texture.wrapT = THREE.ClampToEdgeWrapping;

        const material = new THREE.MeshStandardMaterial({
            map: texture,
            color: 0xffffff,
        });

        const poster = new THREE.Mesh(posterGeometry, material);
        poster.position.x = x;
        poster.name = imagePath;

        rowGroup.add(poster);
    });
}

function shuffleList(list) {
    const result = [];

    while (list.length) {
        const i = Math.floor(Math.random() * list.length);
        result.push(list.splice(i, 1)[0]);
    }

    return result;
}

function roundedRect(ctx, x, y, width, height, radius) {
    ctx.moveTo(x, y + radius);
    ctx.lineTo(x, y + height - radius);
    ctx.quadraticCurveTo(x, y + height, x + radius, y + height);
    ctx.lineTo(x + width - radius, y + height);
    ctx.quadraticCurveTo(x + width, y + height, x + width, y + height - radius);
    ctx.lineTo(x + width, y + radius);
    ctx.quadraticCurveTo(x + width, y, x + width - radius, y);
    ctx.lineTo(x + radius, y);
    ctx.quadraticCurveTo(x, y, x, y + radius);
}

window.stopAnimation = () => {
    disableAnimate = 'true';
};